<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Pilih Role - Harris Absensi</title>

    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap');

        * {
            font-family: 'Poppins', sans-serif;
        }

        body {
            background: #f5f5f5;
            min-height: 100vh;
        }

        .role-card {
            transition: all 0.2s ease;
            cursor: pointer;
        }

        .role-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
        }

        .role-card.selected {
            border-color: #FF6B35;
            box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
        }

        .role-icon {
            width: 64px;
            height: 64px;
            margin: 0 auto 1rem;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
        }

        .gradient-bg {
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C42 100%);
        }

        .btn-submit {
            transition: all 0.2s ease;
        }

        .btn-submit:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(255, 107, 53, 0.3);
        }
    </style>
</head>

<body>
    <div class="min-h-screen flex items-center justify-center p-4">
        <div class="w-full max-w-4xl">

            <!-- Header -->
            <div class="text-center mb-8">
                <div class="mb-4">
                    <img src="{{ asset('img/Logo.png') }}" alt="HARRIS Hotel Logo" class="h-20 mx-auto object-contain">
                </div>
                <h1 class="text-2xl md:text-3xl font-bold text-gray-800 mb-2">
                    Selamat Datang, {{ $user->nama }}!
                </h1>
                <p class="text-gray-600">
                    Pilih mode akses yang ingin Anda gunakan
                </p>
            </div>

            <!-- Role Selection Cards -->
            <form action="{{ route('role.set') }}" method="POST" id="roleForm">
                @csrf
                <input type="hidden" name="selected_role" id="selected_role">

                <div class="grid md:grid-cols-2 gap-6 mb-6">
                    <!-- Admin Card -->
                    <div class="role-card bg-white rounded-xl shadow-md p-6 border-2 border-transparent"
                         onclick="selectCard('admin', this)">
                        <div class="role-icon gradient-bg text-white">
                            <i class="fas fa-user-shield"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-800 mb-2 text-center">
                            Mode Admin
                        </h3>
                        <p class="text-gray-600 text-center text-sm mb-4">
                            Kelola sistem, karyawan, dan data absensi
                        </p>
                        <ul class="space-y-2 text-sm text-gray-700">
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                Kelola data karyawan
                            </li>
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                Approval pengajuan
                            </li>
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                Monitoring & laporan
                            </li>
                        </ul>
                    </div>

                    <!-- Karyawan Card -->
                    <div class="role-card bg-white rounded-xl shadow-md p-6 border-2 border-transparent"
                         onclick="selectCard('karyawan', this)">
                        <div class="role-icon bg-blue-500 text-white">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-800 mb-2 text-center">
                            Mode Karyawan
                        </h3>
                        <p class="text-gray-600 text-center text-sm mb-4">
                            Absensi harian dan pengajuan cuti
                        </p>
                        <ul class="space-y-2 text-sm text-gray-700">
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-blue-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                Absensi masuk & pulang
                            </li>
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-blue-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                Pengajuan cuti
                            </li>
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-blue-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                Riwayat absensi
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Submit Button -->
                <button type="submit" id="submitBtn" disabled
                        class="btn-submit w-full gradient-bg text-white py-3 rounded-lg font-semibold disabled:opacity-50 disabled:cursor-not-allowed">
                    <i class="fas fa-arrow-right mr-2"></i>
                    Lanjutkan
                </button>
            </form>

            <!-- Info Box -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mt-6">
                <div class="flex items-start">
                    <svg class="w-5 h-5 text-blue-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                    </svg>
                    <p class="text-sm text-blue-800">
                        Anda dapat beralih mode kapan saja melalui menu profil setelah login.
                    </p>
                </div>
            </div>

            <!-- Logout Button -->
            <div class="text-center mt-6">
                <form action="{{ route('logout') }}" method="POST" class="inline">
                    @csrf
                    <button type="submit" class="text-gray-600 hover:text-orange-600 font-medium inline-flex items-center text-sm">
                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        Keluar
                    </button>
                </form>
            </div>

        </div>
    </div>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <script>
        function selectCard(role, card) {
            // Remove selected class from all cards
            document.querySelectorAll('.role-card').forEach(c => {
                c.classList.remove('selected');
            });

            // Add selected class to clicked card
            card.classList.add('selected');

            // Set hidden input value
            document.getElementById('selected_role').value = role;

            // Enable submit button
            document.getElementById('submitBtn').disabled = false;
        }

        // Prevent form submission if no role selected
        document.getElementById('roleForm').addEventListener('submit', function(e) {
            const selectedRole = document.getElementById('selected_role').value;
            if (!selectedRole) {
                e.preventDefault();
                alert('Silakan pilih mode akses terlebih dahulu');
            }
        });
    </script>
</body>

</html> 
